﻿
Module.modify :UniversalAMQ do
	methods :class_XSDComplexType => <<-'METHOD'
		# {}
		# Класс для создания комплекстных/структурных xsd-типов
		class XSDComplexType < XSDBase
			def initialize _name, xsdSchema = nil
				# инициализация объекта, где:
				#   _name     - наименование типа / вставляемого тега структуры
				#   xsdSchema - объект xsd-схемы, напремер как текущий
				super()
				if _name.nil?
					@name = nil
				else
					_name = _name.to_s.to_sym unless _name.is_a?(Symbol)
					@name = _name
				end
				@schema = xsdSchema
				@prefix = nil
			end
			
			def name 
				# позволяет получить наименование типа, оно же наименование тега
				@name
			end
			
			def prefix
				# позволяет получить префикс тега в xsd-схеме
				@prefix
			end
			
			def prefix= value
				# позволяет указать префикс тега в xsd-схеме
				@prefix = value
			end
			
			def fullname
				# возвращает полное имя тега, включая его префикс
				if @prefix.nil?
					@name
				else
					"#{@prefix}:#{@name}".to_sym
				end
			end
			
			def method_missing type, *args, &block
				# данный метод позволяет формировать набор структуры, указывая ее в стиле C/C++ структуры, с вложенностями в стиле DSL
				if DEFAULT_TYPE.include?(type)
					element args.shift, type, &block
				elsif !@schema.nil? && @schema.allTypes.include?(type)
					ref type, &block
				else
					raise "Типа данных '#{type}' несуществует" 
				end
				self
			end
			
			def container _name, &block
				# !!! еще не дороботан до ума, пока непользоваться !!!   -- если понадобиться доработать!
				# предполагался как создание вложенной подструктуры без его создания выше
				type = XSDComplexType.new nil, self
				type.instance_eval(&block) if block_given?
				
				elem = XSDElement.new(_name, @schema).type(type)
				elem.instance_eval(&block) if block_given?
				@elements << elem
				
				self
			end
			
			def to_s tabs = ''
				# метод преобразовывает объект в его описание в XSD-схеме
				tabs = "\t" * tabs if tabs.is_a?(Integer)
				tabs = tabs.to_s unless tabs.is_a?(String)
				result = [
					"#{tabs}<xsd:complexType", 
					@name.nil? ? '' : " name=\"#{@name}\"",
					">\n"
				]
				
				unless @elements.empty?
					result << "#{tabs}\t<xsd:sequence>\n"
					@elements.each do |nm,elem| 
						if elem.is_a? XSDComplexType
							result << "#{tabs}\t\t#{elem.to_s tabs}\n"
						else
							result << "#{tabs}\t\t#{elem}\n"
						end
					end
					result << "#{tabs}\t</xsd:sequence>\n"
				end
				
				unless @attrs.empty?
					@attrs.each{|nm,attr| result << "#{tabs}\t#{attr}\n" }
				end
				
				result << "#{tabs}</xsd:complexType>\n\n"
				
				result.join
			end
			
			def to_node up_node = nil
				# метод преобразовывает объект в узел типа UniversalXML::Node, в его XSD-вид
				node = unless up_node.nil? 
					up_node.create_node :complexType
				else
					User::UniversalXML::Node.new :complexType
				end
				
				node.prefix 'xsd'
				node.attr :name, @name
				
				unless @elements.empty?
					sequence = node.create_node :sequence
					sequence.prefix 'xsd'
					@elements.each{|nm,elem| elem.to_node sequence}
				end
				
				unless @attrs.empty?
					@attrs.each{|nm,attr| attr.to_node node }
				end
				
				node
			end
			
			def to_h
				# метод преобразовывает объект в простой Hash, с данными настройки объекта
				result = @name.nil? ? {} : {name: @name}
				result[:prefix] = @prefix unless prefix.nil?
				result[:sequence] = @elements.values.map(&:to_h) unless @elements.empty?
				result[:attributes] = @attr.values.map(&:to_h) unless @attrs.empty?
				result
			end
			
		end
	METHOD
end
