﻿
Module.modify :UniversalAMQ do
	methods :class_XSDElement => <<-'METHOD'
		# {}
		# Класс для создания xsd-елементов, а так же их преобразование в XML
		class XSDElement
			INFINITY_MAX_OCCURS = :unbounded #неограниченное кол-во раз в документеб только для maxOccurs
			
			def initialize _name = nil, xsdSchema = nil
				# инициализация объекта, где:
				#   _name     - наименование типа / вставляемого тега структуры
				#   xsdSchema - объект xsd-схемы, напремер как XSDComplexType
				_name = _name.to_s.to_sym if !_name.nil? && !_name.is_a?(Symbol)
				@name = _name
				@type = nil
				@ref = nil
				@minOccurs = nil
				@maxOccurs = nil
				@default = nil
				@fixed = nil
				@schema = xsdSchema
				@subelement = nil
			end
			
			def name _name = nil
				# получение наименование текущего элемента/тега/поля структуры, если не передавать значение, или устанавливает в указанное значение
				return @name if _name.nil?
				_name = _name.to_s.to_sym unless _name.is_a?(Symbol)
				@name = _name
				self
			end
			
			
			
			private
			def to_prefix_s _type
				# возвращает описание указанного типа данных для вставки в xsd-схему
				if DEFAULT_TYPE.include?(_type)
					USE_TYPE_TO_XSD_TYPE[_type]
				elsif !@schema.nil? && @schema.allTypes.include?(_type)
					prefix = @schema.prefixType(_type)
					(prefix.nil? ? '' : "#{prefix}:") + _type.to_s
				else
					_type.to_s
				end
			end
			public
			
			def type _type = nil
				# возвращает тип данных текущего элемента/тега/поля структуры, если не передавать значение, или устанавливает новый указанный тип данных
				return @type if _type.nil?
				_type = _type.to_s.to_sym unless _type.is_a?(Symbol)
				@type = _type
				self
			end
			
			def ref _ref = nil
				# позволяет получить ссылку на другую структуру, которая должна вкладываться в текущий тег, или устанавливает новую, если передать параметр
				return @ref if _ref.nil?
				_ref = _ref.to_s.to_sym unless _ref.is_a?(Symbol)
				@ref = _ref
				self
			end
			
			def minOccurs min = nil
				# метод возвращает минимальное количество повторений данного тега в структуре, если не передавать параметр, или позволяет установить указанное
				return @minOccurs if min.nil?
				raise "Можно указать только целое положительное число, значение '#{min}' является ошибкой" unless min.is_a?(Integer)
				raise "Значение не должно быть отрицательным" if min < 0
				@maxOccurs = min if @maxOccurs.is_a?(Integer) && min > @maxOccurs 
				
				@minOccurs = min
				self
			end
			
			def maxOccurs max = nil
				# метод возвращает максимальное количество повторений данного тега в структуре, если не передавать параметр, или позволяет установить указанное
				# параметр max может быть как целым положительным числом, так и значением :unbounded, которое означает "неограниченное кол-во"
				return @maxOccurs if max.nil?
				raise "Можно указать только целое положительное число или :unbounded, значение '#{max}' является ошибкой" unless max.is_a?(Integer) || max == :unbounded
				raise "Значение не должно быть отрицательным" if max.is_a?(Integer) && max < 0
				@minOccurs = max if max.is_a?(Integer) && @minOccurs.is_a?(Integer) && max < @minOccurs 
				
				@maxOccurs = max
				if max == 0
					@default = nil
					@fixed = nil
				end
				
				self
			end
			
			def use _type
				# метод позволяет указать определение элемента (обязательное, необязательное/опциональное, запрещенное)
				_type = _type.to_s.to_sym unless _type.is_a?(Symbol)
				raise "значение '#{_type}' нельзя установить, доступные значения смотирте в UniversalAMQ::XSDAttribute::USE_VALUE" unless XSDAttribute::USE_VALUE.include?(_type)
				
				case _type
					when :required
						minOccurs 1
						
					when :optional
						minOccurs 0
						
					when :prohibited
						maxOccurs 0
				end
				
				self
			end
			
			def default value = nil
				# позволяет получить установленное значение по умолчанию, если не передавать ничего, или установить таковое
				return @default if value.nil?
				@default = value
				@fixed = nil
				self
			end
			
			def fixed value = nil
				# позволяет посмотреть зафиксированное значение поля, если не передавать никаких параметров, или установить таковое
				return @fixed if value.nil?
				@default = nil
				@fixed = value
				self
			end
			
			def default?
				# возвращает true, если было установленно значение поумолчанию, и false в противном случае
				!@default.nil?
			end
			
			def fixed?
				# возвращает true, если было зафиксированно значение, и false в противном случае
				!@fixed.nil?
			end
			
			def name?
				# возвращает true, если у текущего элемента/тега/поля есть наименование, и fasle в противном случае
				!@name.nil?
			end
			
			def type?
				# возвращает true, если установлен тип данных текущего элемента/тега/поля, и false в противном случае
				!@type.nil?
			end
			
			def ref?
				# возвращает true, если элемент ссылается на другую структуру, и false в противном случае
				!ref.nil?
			end
			
			def minOccurs?
				# возвращает true, если установленно минимальное кол-во появления текущего элемента/тега/поля в структуре
				!@minOccurs.nil?
			end
			
			def maxOccurs?
				# возвращает true, если установленно максимальное кол-во появления текущего элемента/тега/поля в структуре
				!@maxOccurs.nil?
			end
			
			def to_module_methodTo
				# генерирует строку-скрипт преобразования хеш-данных в XML-документ
				tp = !@ref.nil? ? @ref : (!@type.nil? ? @type : nil)
				nm = !@ref.nil? ? @ref : (!@name.nil? ? @name : nil)
				unless tp.nil?
					min = @minOccurs.nil? ? 1 : @minOccurs;
					max = @maxOccurs.nil? ? min : @maxOccurs;
				
					if max == :unbounded || max > 1
						"(data.is_a?(Array) ? data : data[:#{tp}]).each{|elem| to_#{tp} elem, node}\n"
					elsif max == 1
						res = if DEFAULT_TYPE.include?(tp)
							"node.create_node(:#{nm}).text = User::UniversalAMQ.def_type_to_s( data[:#{nm}], :#{tp} )"
						else
							"to_#{tp}( data[:#{nm}], node)"
						end
						res += " if data.key?(:#{nm})" if min == 0
						res + "\n"
					else
						''
					end
				else
					''
				end
			end
			
			def to_s
				# метод преобразовывает объект в его описание в XSD-схеме
				[
					'<xsd:element',
					@name.nil? ? '' : " name=\"#{@name}\"",
					@ref.nil? ? '' : " ref=\"#{to_prefix_s(@ref)}\"",
					@type.nil? ? '' : " type=\"#{to_prefix_s(@type)}\"",
					@minOccurs.nil? ? '' : " minOccurs=\"#{@minOccurs}\"",
					@maxOccurs.nil? ? '' : " maxOccurs=\"#{@maxOccurs}\"",
					@default.nil? ? '' : " default=\"#{@default}\"",
					@fixed.nil? ? '' : " fixed=\"#{@fixed}\"",
					'/>'
				].join
			end
			
			def to_node up_node = nil
				# метод преобразовывает объект в узел типа UniversalXML::Node, в его XSD-вид
				node = unless up_node.nil? 
					up_node.create_node :element
				else
					User::UniversalXML::Node.new :element
				end
				node.prefix 'xsd'
				node.attr(:name, @name)              unless @name.nil?
				node.attr(:type, to_prefix_s(@type)) unless @type.nil?
				node.attr(:ref, to_prefix_s(@ref))   unless @ref.nil?
				node.attr(:minOccurs, @minOccurs)    unless @minOccurs.nil?
				node.attr(:maxOccurs, @maxOccurs)    unless @maxOccurs.nil?
				node.attr(:default, @default)        unless @default.nil?
				node.attr(:fixed, @fixed)            unless @fixed.nil?
				
				node
			end
			
			def to_h
				# метод преобразовывает объект в простой Hash, с данными настройки объекта
				result = {}
				result[:name]      = @name              unless @name.nil?
				result[:type]      = to_prefix_s(@type) unless @type.nil?
				result[:ref]       = to_prefix_s(@ref)  unless @ref.nil?
				result[:minOccurs] = @minOccurs         unless @minOccurs.nil?
				result[:maxOccurs] = @maxOccurs         unless @maxOccurs.nil?
				result[:default]   = @default           unless @default.nil?
				result[:fixed]     = @fixed             unless @fixed.nil?
				
				result
			end
		end
	METHOD
end
