﻿
Module.modify :UniversalAMQ do
	methods :class_XSDSchema => <<-'METHOD'
		# {}
		# Класс для создания XSD-схемы данных, а так же создания модуля с преобразованием тех же структур, для формирования XML-документов
		class XSDSchema < XSDBase
			# для создания собственных простых типов. //п.с. на заметку, для развития модуля
			#	<xsd:simpleType name=...>...desc...</xsd:simpleType>
			#
			#	"desc" может быть:
			#		наследованием   (<xsd:restriction base=...>...paramType...</xsd:rectriction>)
			#		листом значений (<xsd:list itemType=.../>)
			#		объединением    (<xsd:union memberTypes=.../>)
			#
			#	"paramType" имеют следующие вложенные элементы:
			#		шаблон (рег.выражение)           (<xsd:pattern value=.../>)
			#		набор значений  (не для boolean) (<xsd:enumeration value=.../>)
			#		для строк ( STRING_TYPE + List ):
			#			размер значения              (<xsd:length value=.../>)
			#			минимальный размер значения  (<xsd:minLength value=.../>)
			#			максимальный размер значения (<xsd:maxLength value=.../>)
			#			тип разделителя              (<xsd:whiteSpace value="preserve | replace | collapse"/>)
			#				+ для boolean
			#		для числовых типов ( DECIMAL_TYPE + DATETIME_TYPE + float + double ):
			#			maxInclusive
			#			maxExclusive
			#			minInclusive
			#			minExclusive
			#		для целочисленных типов ( DECIMAL_TYPE )
			#			максимальное кол-во цифр                   (<xsd:totalDigit value=...>)
			#			максимальное кол-во цифр в дробной части   (<xsd:fractionDigits value=...>)
			
			def initialize _name
				# инициализация объекта формирования XSD-схемы, и генерирования соответствующего модуля конвертации данных, где
				#   _name - имя модуля и бинарного файла XSD-схемы, который будет сохранен в бау данных вектора в бинарных файлах, с расширением ".xsd"
				super()
				@complexTypes = {}
				@name = _name
				@scheme = self
				@namespaces = {}
				@desc = Time.now.to_s
				# 
				#if pathOrNode.nil?
				#else
				#	pathOrNode = User::UnifersalXML::Node.load(pathOrNode) if pathOrNode.is_a?(String)	
				#end
				
				
			end
			
			def description text = nil
				# позволяет получить описание/коментарий схемы, если параметр не передан, или установить новое описание/коментарий схемы, которое будет записано в модуль, а так же в сам файл XSD-схемы
				return @desc if text.nil?
				@desc = "#{text} #{Time.now}"
			end
			
			def namespace prefix, url
				# позволяет зарегестрировать окружение имен внутри xsd-схемы
				@namespaces[prefix] = url
			end
			
			def method_missing type, *args, &block
				# данный метод позволяет формировать набор структуры, указывая ее в стиле C/C++ структуры, с вложенностями в стиле DSL
				if DEFAULT_TYPE.include?(type)
					element args.shift, type, &block
				elsif allTypes.include?(type)
					ref type, &block
				else
					raise "Типа '#{type}' несуществует" 
				end
				self
			end
			
			def allTypes
				# возвращает имена всех созданных структур
				@complexTypes.keys
			end
			
			def getTypes
				# возвращает полные имена всех созданных структур, которые будет сохранены в xsd-схему
				@complexTypes.inject([]){|res,type| res << type[1].fullname}.uniq
			end
			
			def prefixType type
				# позволяет получить префикс ранее созданной структуры
				@complexTypes[type].prefix
			end
			
			def namespace? prefix
				# проверяет существует ли окружение имен для префикса
				@complexTypes.key? prefix
			end
			
			def name
				# возвращает название текущей XSD-схемы
				@name
			end
			
			def container _name, prefix = nil, &block
				# создает контейнер/структуру данных, где 
				#   _name  - наименование типа/структуры/тега
				#   prefix - если необходимо, можно указать конкретный префикс, который необходимо зарегистрировать в данной XSD-схеме
				#   &block - программный блок, в котором производиться описание структуры данных
				type = XSDComplexType.new _name, self
				type.prefix = prefix unless prefix.nil?
				type.instance_eval(&block) if block_given?
				@complexTypes[_name] = type
				@complexTypes[type.fullname] = type
				element _name, type.fullname
				self
			end
			
			def to_s tabs = ''
				# метод преобразовывает объект в его описание в XSD-схеме
				tabs = "\t" * tabs if tabs.is_a?(Integer)
				tabs = tabs.to_s unless tabs.is_a?(String)
				result = [
					tabs == '' ? "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" : '',
					"#{tabs}<xsd:schema xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"",
					@namespaces.empty? ? '' : @namespaces.map{|key,val| " xmlns:#{key}=\"#{val}\""}.join,
					">\n#{tabs}\t<xsd:annotation>\n#{tabs}\t\t<xsd:documentation xsml:lang=\"ru\">\n#{tabs}\t\t\t#{@desc}\n#{tabs}\t\t</xsd:documentation>\n#{tabs}\t</xsd:annotation>\n\n"
				]
				
				unless @attrs.empty?
					@attrs.each{|nm,attr| result << tabs + "\t#{attr}\n" }
					result << "\n"
				end
				
				@elements.each{|nm,elem| result << tabs + "\t#{elem}\n\n" }
				
				unless @complexTypes.empty?
					getTypes.each{|nameType| result << @complexTypes[nameType].to_s( tabs + "\t")}
				end
				
				result << tabs + "</xsd:schema>"
				
				result.join
			end
			
			def to_module module_name = nil
				# данный метод генерирует вспомогательный модуль, в который будет сгенерированы методы конвертации ruby-структуры в XML-структуру
				#   module_name - если не указывать данный параметр, то модуль будет создан с тем именем, которое было переданно в инициализацию, если же указать, то будет создан с указанным именем
				module_name = @name if module_name.nil?
				hashMethods = {}
				getTypes.each do |nameType|
					elem = @complexTypes[nameType]
					
					#attrs = @attrs.map{|nm, attr| attr.to_module_methodTo}
					#elements = @elements.map{|nm, elem| elem.to_module_methodTo}
					
					hashMethods["to_#{elem.name}".to_sym] =  %Q{ # {}
						def self.to_#{elem.name} data, up_node = nil
							node = unless up_node.nil? 
								up_node.create_node :#{elem.name}
							else
								User::UniversalXML::Node.new :#{elem.name}
							end
							
							#{elem.to_module_methodTo}
							
							node
						end
					}
				end
				
				hashMethods[:saveXSD] = %Q{ # {}
					def self.saveXSD file_name
						User::UniversalAMQ.getXSD '#{@name}', file_name
					end
				}
				
				desc = @desc
				User::Module.recreate module_name do
					description desc
					methods hashMethods
				end
			end
			
			def saveXSD to_file_path
				# метод сохраняет описанную в объекте XSD-схему в указанный файл, на локальной машине
				User::UniversalAMQ.getXSD @name.to_s, to_file_path
			end
		end
	METHOD
end
