﻿
Module.modify :UniversalAMQ do
	methods :self_create => <<-'METHOD'
		# {}
		# Метод для создания XSD-схемы и модуля для преобразования описанных в нем типов данных для формирования XML-документов
		def self.create name, &block
			# name   - наименование модуля/XSD-схемы
			# &block - настройка схемы в стиле DSL

			xsd = XSDSchema.new name
			xsd.instance_eval(&block) if block_given?
			
			# создаем/пересоздаем модуль, для работы с созданными типами
			xsd.to_module
			
			# ищем созданный ранее файл, чтобы его заменить, а не создавать новый, если же файла нет, то создадим новый
			file_name = name.to_s
			bin_id = nil
			User::Binary.each do |id,bin|
				if bin.name == file_name && bin.file_ext == '.xsd'
					desc = bin.description unless desc
					bin_id = id
					break
				end
			end
			
			# формируем данные файла для их сохранения
			desc = xsd.description
			text = xsd.to_s ''
			file_hash = Digest::MD5.hexdigest(text).to_s
			byte_array = text.to_java_bytes.to_a
			descriptor = [bin_id,file_name,desc,file_name,".xsd",byte_array.size,Time.now,file_hash,byte_array,nil]

			# сообщаем вектору, что файл был создан или изменен, для нотификации
			if descriptor[0] == nil
				$space.binaryAccount._insert *descriptor
			else
				$space.binaryAccount._update *descriptor
			end
			

			# возвращаем объект схемы, например что бы в этом же коде передать XSD-схему куда-нибудь еще
			xsd
		end
	METHOD
end
