
Module.modify :UniversalAMQ do
	methods :self_def_type_to_s => <<-'METHOD'
		# {}
		# Метод для приведения простых типов данных в необходимый простой тип XSD-схемы (с учетом границ типа)
		def self.def_type_to_s value, type
			raise "тип данных '#{type}' не является встроенным, ознакомитться с доступными типами можно вызвав UniversalAMQ::DEFAULT_TYPE" unless DEFAULT_TYPE.include?(type)
			require 'base64'
			require 'bigdecimal'
			
			case type
				when :string
					value.to_s
				
				when :normString   # все символы перевода строки, табуляции, и перевода каретки преобразуются в обычный пробел (xsd:normalizedString)
					value.to_s.tr("\t\n\r",' ')
				
				when :token   # как normString, но смежные пробелы сокращаются до одного, начальные и конечные удаляются
					value = value.to_s.tr("\t\n\r",' ')
					if value.size > 200
						value.squeeze
					else
						value['  '] = ' ' while value['  ']
						value
					end
					
				
				when :base64   # GpM7  (xsd:base64Binary)
					Base64.encode64(value.to_s)
					
					
				when :hex   # 0FB7  (xsd:hexBinary)
					if value.is_a? Integer
						value.to_s(16)
					elsif value.is_a?(String)
						value = value.split(/[^0-9a-fA-F]+/).join if value[/[^0-9a-fA-F]+/]
						value
					else
						values.to_s.to_i.to_s(16)
					end
				
				when :anyUri    # http://www.example.com/, http://www.example.com/doc.html#ID5
					value = 'http://' + value unless t[/^https?:\/\//]
					value
				
				when :language      # en-GB, en-US, fr
					value.to_s
			
				when :decimal   # числовое значение больших размеров, может быть как целым, так и вещественным (по стандарту все процессоры должны поддерживать не меньше 18 цифр)
					if value.is_a? BigDecimal
						value.to_s('F')
					else
						value.to_s
					end
				
				when :integer  # base(decimal) <- без дробной части
					if value.is_a? BigDecimal
						value.to_i.to_s
					else
						value.to_s
					end
						
				when :pInteger  # base(integer) # > 0  // xsd:positiveInteger
					value = value.to_i unless value.is_a? Integer
					if value < 1
						'1'
					else
						value.to_s
					end
					
				when :nInteger  # base(integet) # < 0  // xsd:negativeInteger
					value = value.to_i unless value.is_a? Integer
					if value > -1
						'-1'
					else
						value.to_s
					end
				
				when :nnInteger # base(integer) # >= 0 // xsd:nonNegativeInteger
					value = value.to_i unless value.is_a? Integer
					if value < 0
						'0'
					else
						value.to_s
					end
				
				when :npInteger # base(integer) # <= 0 // xsd:nonPositiveInteger
					value = value.to_i unless value.is_a? Integer
					if value > 0
						'0'
					else
						value.to_s
					end
				
				when :tiny      # +- 1 byte            // xsd:byte
					value = value.to_i unless value.is_a? Integer
					if value < -128
						'-128'
					elsif value > 127
						'127'
					else
						value.to_s
					end
					
				when :byte      # +  1 byte            // xsd:unsignedByte
					value = value.to_i unless value.is_a? Integer
					if value < 0
						'0'
					elsif value > 255
						'255'
					else
						value.to_s
					end
				
				when :small     # +- 2 byte            // xsd:short
					value = value.to_i unless value.is_a? Integer
					if value < -32768
						'-32768'
					elsif value > 32767
						'32767'
					else
						value.to_s
					end
				
				when :word      # +  2 byte            // xsd:unsignedShort
					value = value.to_i unless value.is_a? Integer
					if value < 0
						'0'
					elsif value > 65535
						'65535'
					else
						value.to_s
					end
					
				when :int       # +- 4 byte
					value = value.to_i unless value.is_a? Integer
					if value < -2_147_483_648
						'-2147483648'
					elsif value > 2_147_483_647
						'2147483647'
					else
						value.to_s
					end
					
				when :dword     # +  4 byte            // xsd:unsignedInt
					value = value.to_i unless value.is_a? Integer
					if value < 0
						'0'
					elsif value > 4_294_967_295
						'4294967295'
					else
						value.to_s
					end
					
				when :long      # +- 8 byte
					value = value.to_i unless value.is_a? Integer
					if value < -9_223_372_036_854_775_808
						'-9223372036854775808'
					elsif value > 9_223_372_036_854_775_807
						'9223372036854775807'
					else
						value.to_s
					end
					
				when :qword      # +  8 byte            // xsd:unsignedLong
					value = value.to_i unless value.is_a? Integer
					if value < 0
						'0'
					elsif value > 18446744073709551615
						'18446744073709551615'
					else
						value.to_s
					end
			
				when :time      # 13:20:00.000, 13:20:00.000-05:00
					value = Time.parse(value) if value.is_a?(String)
					value.strftime('%H:%M:%S.%L')
					
				when :dateTime  # 1999-05-31T13:20:00.000-05:00 => 31 мая 1999 года 13 часов 20 минут Восточноевропейского стандартного времени, которое на 5 часов отстает от Универсального времени
					value = Time.parse(value) if value.is_a?(String)
					value.strftime('%Y-%m-%dT%H:%M:%S.%L%:z')
					
				when :duration  # P1Y2M3DT10H30M12.3S => 1 год, 2 месяца, 3 дня, 10 часов, 30 минут, и 12.3 секунды
					value = Time.parse(value) if value.is_a?(String)
					value.strftime('P%---YY%-mM%-dDT%kH%MM%S.%LS')
					
				when :date      # 1999-05-31
					value = Time.parse(value) if value.is_a?(String)
					value.strftime('%Y-%m-%d')
				
				when :month     # --05-- => май                                           // xsd:gMonth
					value = Time.parse(value) if value.is_a?(String)
					value.strftime('--%m--')
					
				when :year      # 1999                                                    // xsd:gYear
					value = Time.parse(value) if value.is_a?(String)
					value.strftime('%Y')
				
				when :yearMonth # 1999-02 => Февраль 1999 года, не зависимо от номера дня // xsd:gYearMonth
					value = Time.parse(value) if value.is_a?(String)
					value.strftime('%Y-%m')
				
				when :day       # ---31 => 31 день                                        // xsd:gDay
					value = Time.parse(value) if value.is_a?(String)
					value.strftime('---%d')
				
				when :monthDay   # --05-31 => 31 мая                                       // xsd:gMonthDay
					value = Time.parse(value) if value.is_a?(String)
					value.strftime('--%m-%d')
			
				when :float,   # вещественное значение малой точности (4 байта)
					 :double  # вещественное значение большой точности (8 байт)
					value = value.to_f unless value.is_a? Float
					if value.nan?
						'NaN'
					elsif (inf = value.infinity?).nil?
						inf > 0 ? 'INF' : '-INF'
					else
						value.to_s
					end
					
				when :boolean
					[false, 0, 0.0, 'false', 'f', 'no', 'off', '0', '', nil].include?(value) ? 'false' : 'true'
			end
			
		end
	METHOD
end
