﻿Module.modify :UniversalAMQ do
	methods :self_getXML => <<-'METHOD'
		# {}
		# Метод для получения XML-документа по ранее созданной XSD-схемы данных, с автоматическим преобразованием из Ruby-структуры в указанную структуру выходного XML-документа
		def self.getXML name_module, get_type, data, ref_node = false
			# name_module - имя модуля, который был ранее создан описанием XSD-схемы
			# get_type    - название типа-структуры, с которого начинать вормировать XML
			# data        - данные в руби-структуре (например хеш хешей)
			# ref_node:
			#   true  - вернет массив из двух элементов: [<XML-документ>, <объект UniversalXML::Node с данными>]
			#   false - вернет <XML-документ>
			
			node = User.const_get(name_module).send("to_#{get_type}".to_sym, data) 
			
			res = [
				"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n",
				node.to_text( true, [:cdata, :esc, :small_end])
			].join
			
			ref_node ? [res, node] : res
			
		end
	METHOD
end