﻿
Module.modify :UniversalAMQ do
	methods :self_getXSD => <<-'METHOD'
		# {}
		# Метод для получения/сохранения ранее созданной XSD-схемы данных
		def self.getXSD name, to_file_path = nil
			# name         - имя модуля/файла, который был ранее создан описанием XSD-схемы
			# to_file_path - путь по которому сохранить файл на локальный ПК, если не указывать, то только вернет XSD-схему в виде строки
			name = name.to_s unless name.is_a? String
			
			# ищем созданный ранее файл, чтобы его заменить, а не создавать новый, если же файла нет, то создадим новый
			binary = nil
			User::Binary.each do |id,bin|
				if bin.name == name && bin.file_ext == '.xsd'
					binary = bin
					break
				end
			end
			
			unless binary.nil?
				result = binary.text
				File.open(to_file_path, 'w+:utf-8') { |file| file.write result } unless to_file_path.nil?	
				result
			else
				''
			end
		end
	METHOD
end
