﻿
Module.modify :UniversalAMQ do
	methods :self_ibm_send => <<-'METHOD'
		# {}
		# Класс для простой работы с IBM MQ.
		class SendIbmMQ
			# подгрузка необходимых java-библиотек, для работы с IBM MQ
			java_import com.ibm.mq.jms.MQConnectionFactory
			java_import com.ibm.mq.jms.MQQueue
			java_import com.ibm.msg.client.wmq.WMQConstants
			java_import ru.ts.aoc.api.j2ee.AOCConfig
			java_import ru.ts.aoc.api.j2ee.AOCInterface
			java_import ru.ts.aoc.api.j2ee.AOCMessage
			java_import ru.programpark.ibmmq.Unloader
			
			def initialize
				self.transient :cfg
				self.transient :cf
				self.transient :intf
				@cfg = ru.ts.aoc.api.j2ee.AOCConfig.new
				@cf = MQConnectionFactory.new
				@cf.transport_type = WMQConstants::WMQ_CM_CLIENT
				@cfg.connection_factory = @cf
			end
			
			# === Settings MQConnectionFactory === # 
			
			def host host_name
				# метод позволяет настроить адрес сервера, с которым необходимо работать
				@cf.host_name = host_name
				self
			end
			
			def port port_num
				# настройка порта, по которому необходимо подключаться
				@cf.port = port_num
				self
			end
			
			def queue queue_manager
				# настройка наименование очереди
				@cf.queue_manager = queue_manager
				self
			end
			
			def channel channel_name
				# маршрутный адрес панели, которая видимо будет отслеживать сообщения
				@cf.channel = channel_name
				self
			end
			
			def type transport_type
				# тип передачи сообщений, если неуказывать, то будет какой-то стандартный
				@cf.transport_type = transport_type
				self
			end
			
			# === Settings ru.ts.aoc.api.j2ee.AOCConfig === #
			
			def ccsid ccsid_num
				# идентификатор какого-то модуля на той стороне (число)
				@cfg.ccsid = ccsid_num
				self
			end
			
			def keep_connect keep
				# тип соединения, может быть true или false
				@cfg.keep_connect = keep
				self
			end
			
			def queue_put q
				# очередь приема сообщений
				@cfg.put_destination = MQQueue.new q
				self
			end
			
			def queue_get q
				# очередь получения сообщений
				@cfg.get_destination = MQQueue.new q
				self
			end
			
			def queue_ans q
				# еще какая-то очередь ответа
				@cfg.ans_destination = MQQueue.new q
				self
			end
			
			# === END SETTINGS === #
			
			def start fromAddr, transacted = false
				# метод устанавливает соединение с IBM MQ, где 
				#   fromAddr   - маршрут-адрес от куда мы будем отправлять
				#   transacted - вроде отвечает за отслеживание маршрута отправки, false - отключено
				@intf = nil
				begin
					@intf = AOCInterface.new Unloader.unloadConfig(@cfg), fromAddr
					@intf.transacted = transacted
					@intf.clear
				rescue
					@intf.close if @intf
					return
				end
				true
			end
			
			def stop 
				# останавливает и закрывает соединение

				# это чтение из очереди ответа(успешно отправилось / не успешно), но в том проекте в итоге оно оказалось не нужным
				#reply = @intf.get 2000  # чтение сообщения из очереди
				#@intf.confirm reply, true if reply

				@intf.close
			end
			
			def send toAddr, msg
				# метод отправляет сообщение, где
				#   toAddr - маршрут-адрес кому хотим отправлять сообщение
				#   msg    - сообщение, которое необходимо отправить
				begin
					message = @intf.createMessage msg
					message.to = toAddr
					@intf.put message
				rescue
					stop
					return
				end
				true
			end
		end
		
		def self.ibm_send &block
			# создает объект IBM MQ, и сразу позволяет его настроить в стиле DSL
			if block_given?
				objIbmMQ = SendIbmMQ.new
				objIbmMQ.instance_eval &block
				objIbmMQ
			end
		end
	METHOD
end
