Module.create :M_Events_Driver do
	description "
		Модуль для перенаправления событий в подписавшиеся на него объекты. 
		ВНИМАНИЕ!!! при изменении/пересоздании модуля все подписки и события будут утеряны
		Автор: Сергеев Д.Н.
	"
	methods :class_event => %q{
		@@HashEvents = {}
		class Event
			def initialize source_, group_, event_name_, params
				@params = params
				@group = group_
				@source = source_
				@event_name = event_name_
			end

			def [] index
				@params[index]
			end

			attr_reader :group, :source, :event_name

			def size
				@params.size
			end
			alias_method :length, :size
			alias_method :count, :size

			def each &block
				@params.each(&block)
			end
		end
	},
		:self_to_object => %q{
		def self.to_object obj
			if obj.is_a?(User::M_Indexing) && obj.respond_to?(:get_full_index)
				obj.get_full_index
			elsif obj.is_a?(User::M_Property) && obj.respond_to?(:get_Index)
				obj.get_index
			elsif obj.class != Fixnum && obj.respond_to?(:obj_id)
				obj.obj_id 
			else
				obj
			end
		end
	},
		:self_get_object => %q{
		def self.get_object obj
			if obj.is_a? String
				if obj[/@/]
					User::M_Index[obj]
				else
					User::M_Property[obj]
				end
			elsif obj_id.class == Fixnum
				User::UserObject.get obj
			else
				obj
			end
		end
	
	},
		:self_attach_event => %q{
			def self.attach_event *событие, obj, метод_обработчик
				# obj              - может быть передан сам объект, имеющий свойство obj_id, или сам obj_id
				# метод_обработчик - метод передаваемого объекта, который будет вызываться при возникновении события
				
				group, name = *событие
				group, name = :ALL, group.to_s unless name
				
				@@HashEvents[group] = {} unless @@HashEvents.key? group
				@@HashEvents[group][name] = {} unless @@HashEvents[group].key? name
				obj = to_object obj
				@@HashEvents[group][name][obj] = метод_обработчик
				self
			end
		},
		:self_remove_event => %q{
			def self.drop_event *событие
				group, name = *событие
				group, name = :ALL, group.to_s unless name
				if @@HashEvents.key? group
					@@HashEvents[group].delete name if @@HashEvents[group].key? name
					@@HashEvents.delete group if @@HashEvents[group].empty?
				end
			end
		},
		:self_exec_event_def => %q{
			def self.exec_event_def sender, событие, *данные
				return self unless @@HashEvents.key? :ALL
				if @@HashEvents[:ALL].key? событие
					event = Event.new sender, :ALL, событие, данные
					@@HashEvents[:ALL][событие].each do |obj_id, method|
						begin
							obj = get_object obj_id
							unless obj.nil?
								obj.send method, event if obj.respond_to?(method)
							else
								(self.отписать_от_события событие, obj_id)
								LogUtil.logger.error "При событии '#{событие}' не был найден объект с obj_id = #{obj_id} и была осуществлена автоматическая отписка от события"
							end
						rescue Exception => e
							LogUtil.logger.error "при событии '#{событие}', с переданными данными '#{данные}', подписанный объект '#{obj}' не смог его обработать корректно, вызвав ошибку с сообщением:\n#{e.message}\n\tСтек вызовов:\n#{e.backtrace.join("\n\t")}"
						end
					end
				end
				self
			end
		},
		:self_exec_event => %q{
			def self.exec_event sender, группа, событие, *данные
				return self unless @@HashEvents.key? группа
				if @@HashEvents[группа].key? событие
					event = Event.new sender, группа, событие, данные
					@@HashEvents[группа][событие].each do |obj_id, method| 
						begin
							obj = get_object obj_id
							unless obj.nil?
								obj.send method, event if obj.respond_to?(method)
							else
								(self.отписать_от_события событие, obj_id)
								LogUtil.logger.error "При событии '#{событие}' группы событий '#{группа}' не был найден объект с obj_id = #{obj_id} и была осуществлена автоматическая отписка от события"
							end
						rescue Exception => e
							LogUtil.logger.error "при событии '#{событие}' группы событий '#{группа}', с переданными данными '#{данные}', подписанный объект '#{obj}' не смог его обработать корректно, вызвав ошибку с сообщением:\n#{e.message}\n\tСтек вызовов:\n#{e.backtrace.join("\n\t")}"
						end
					end
				end
				self
			end
		},
		:self_get_events_list => %q{
			def self.get_events_list group = :ALL
				return [] unless group
				@@HashEvents[group].keys
			end
		},
		:self_get_group_list => %q{
			def self.get_group_list
				@@HashEvents.keys
			end
		},
		:self_signed_event => %q{
			def self.signed_event *событие
				# Если передать значение "ALL" или "ВСЕ", в переменную "событие", то будут выданы все объекты, которые подписались на хотя бы 1 событие

				group, name = *событие
				group, name = :ALL, group.to_s unless name
				return [] unless @@HashEvents.key? group
				if ['ALL','ВСЕ'].include? name.to_java.to_upper_case
					@@HashEvents[group].inject([]){|r,i| r << i[1]}.uniq
				else
					@@HashEvents[group][name]
				end
			end
		},
		:self_dispatch_event_def => %q{
			def self.dispatch_event_def событие, obj = nil
				# obj              - может быть передан сам объект, имеющий свойство obj_id, или сам obj_id
				#  
				# Если передать значение "ALL" или "ВСЕ", в переменную "событие", то объект будет отписан от всех событий, на которые бул подписан 
				# (использовать только в крайних случаях)
				#
				# Если не указать "obj" или передать в качестве значения "nil", то будет отписаны все объекты, которые подписались на событие указанное в переменной "событие"
				
				if @@HashEvents.key? :ALL
					if ['ALL','ВСЕ'].include? событие.to_java.to_upper_case
						obj = to_object obj
						@@HashEvents[:ALL].each{|событие, подписка| подписка.delete_if {|o,m| o == obj} }
						@@HashEvents[:ALL].delete событие if @@HashEvents[событие].empty?
						@@HashEvents.delete :ALL if @@HashEvents[:ALL].empty?
					elsif @@HashEvents[:ALL].key? событие
						obj = to_object obj
						if obj.nil?
							@@HashEvents[:ALL][событие].clear
						else
							@@HashEvents[:ALL][событие].delete_if {|o,m| o == obj}
						end
						@@HashEvents[:ALL].delete событие if @@HashEvents[:ALL][событие].empty?
						@@HashEvents.delete :ALL if @@HashEvents[:ALL].empty?
					end
				end
				self
			end
		},
		:self_dispatch_event => %q{
			def self.dispatch_event группа, событие, obj = nil
				# obj              - может быть передан сам объект, имеющий свойство obj_id, или сам obj_id
				#  
				# Если передать значение "ALL" или "ВСЕ", в переменную "событие", то объект будет отписан от всех событий, на которые бул подписан 
				# (использовать только в крайних случаях)
				#
				# Если не указать "obj" или передать в качестве значения "nil", то будет отписаны все объекты, которые подписались на событие указанное в переменной "событие"
				
				группа = :ALL unless группа

				if @@HashEvents.key? группа
					if ['ALL','ВСЕ'].include? событие.to_java.to_upper_case
						obj = to_object obj
						@@HashEvents[группа].each{|событие, подписка| подписка.delete_if {|o,m| o == obj} }
						@@HashEvents[группа].delete событие if @@HashEvents[группа][событие].empty?
						@@HashEvents.delete группа if @@HashEvents[группа].empty?
					elsif @@HashEvents[группа].key? событие
						obj = to_object obj
						if obj.nil?
							@@HashEvents[группа][событие].clear
						else
							@@HashEvents[группа][событие].delete_if {|o,m| o == obj}
						end
						@@HashEvents[группа].delete событие if @@HashEvents[группа][событие].empty?
						@@HashEvents.delete группа if @@HashEvents[группа].empty?
					end
				end
				self
			end
		}
end