User::Module.send  (User::Module.get(:SOAPInit) ? :modify : :create), :SOAPInit do
	description "Модуль инициализации вспомогательных механизмов для SOAP-сервисов. Автор Сергеев Д.Н. Версия 1.0.2+"
	methods :initialize => %q{ #{}
		transient :logger
		attr_accessor :logger
		def initialize
			# создание собственного лога для каждого SOAP-сервиса по адресу: #{log_dir}/soap/#{namesoap}/

			time = Time.now.strftime("%Y_%m_%d")
			log_dir = java.lang.System.getProperty 'log_dir'
			appender = org.apache.log4j.DailyRollingFileAppender.new(
				org.apache.log4j.PatternLayout.new("%d{yyyy-MM-dd HH:mm:ss.SSS} [%p] -- %m%n"),
				"#{log_dir}/soap/#{namesoap}/#{time}.log",
				"'.'yyyy-MM-dd")

			logger = org.apache.log4j.LogManager.getLogger "soap.services"
			logger.removeAllAppenders
			logger.setLevel org.apache.log4j.Level::ALL
			logger.setAdditivity false
			logger.addAppender appender

			@logger = org.apache.commons.logging.impl.Log4JLogger.new logger
		end
	},
	:access? => %q{ #{}
		def access? role
			# метод проверяет наличие роли у пользователя, при включенном режиме авторизации.
			# используется автоматически при включении требования авторизации
			result = true
			result &&= @user.roles.include?( service_role ) unless service_role.nil?
			result &&= @user.roles.include?( role )  unless role.nil?
			result
		end
	},
	:rTime => %q{ #{}
		def	rTime jTime
			# вспомогательный метод, который делает конвертацию java-времени приходящим при типе структуры dateTime, в привычное время ruby (Time)
			Time.parse(jTime.get_time.to_s)
		end
	},
	:hashReKeys => %q{ # #{}
		def hashReKeys data
			# вспомогательный метод, который пробегается по переданной структуре и переводит все строковые ключи в символьные, параллельно убирая nil из значений 
			unless data.is_a?(Hash)
	  			return data.map{|el| hashReKeys el} if data.is_a? Array
				return data
	  		end
			res = {}
				data.keys.each do |key|
					k = if key.is_a?(Symbol) 
						 key
					elsif key.is_a?(String)
						key.to_sym
					else
						key.to_s.to_sym
					end
					v = data[key]
					v = hashReKeys(v) if(v.is_a?(Hash))

					# возможно убирать nil в последних версиях уже неактульно, на текущей реализации при получении nil вне строковых данных выдавалась ошибка конвертации
					res[k] = v.nil? ? '' : v
				end
				res
		end
	}
	
end