User::Module.send  (User::Module.get(:UniversalSOAPhttp) ? :modify : :create), :UniversalSOAPhttp do
	description "Модуль для создания и удаления SOAP-сервисов. Автор Сергеев Д.Н. Версия 1.2.1+"
	methods :constant => %q{ #{}
		DEF_PLUGIN = 'HttpServer'
	},
	:class_SOAPType => %q{ #{}
		class SOAPType
			# Вспомогательный класс-фабрика, предназначенный для генерации структуры данных, которая будет размещена в XML
			
			# доступные типы данных в описании структур
			DEF_TYPE = [:string, :long, :float, :double, :int, :short, :boolean, :dateTime, :base64Binary, :decimal, :integer, :array, :ref]

			def initialize name
				@name = name.to_s.to_sym
				@attrs = {}
			end


			def method_missing type, *args
				# данный метод позволяет формировать набор структуры, указывая ее в стиле C/C++ структуры

				type = type.to_sym
				raise "it is impossible to set the data type #{type}" unless SOAPType::DEF_TYPE.include? type
				name, subtype = args.map(&:to_s).map(&:to_sym)

				# для массивав 2 параметра, так как ожидается указания наименовании тега массива, и наименование структуры элемента массива
				if type == :array
					@attrs[name] = [:array, subtype]
				else
					@attrs[name] = [type]
				end
				self
			end

			def generate_to_soap soap
				# метод генерирует структуру в объект SOAP-сервиса
				attrs = @attrs
				nm = @name
				soap.message @name do
					attrs.each do |name, type|
						if type[0] == :array
							array type[1], name
						else
							send( type[0], name)
						end
					end
				end unless @attrs.empty?
			end

			def generate_to_module hash_methods
				# метод генерирует методы модуля, для конвертирования структуры данных как из возвращаемой структуры в более привычную, логичную, и удобную для работы структуру и обратно.

				lineIn, lineOut = [], []
				@attrs.each do |name, type|
					if type[0] == :array
						lineIn << "#{name}: data[:#{@name}][:#{name}][:#{name}].map{|h| in_#{type[1]}(h)}"
						lineOut << "#{name}: {#{name}: data[:#{name}].map{|h| out_#{type[1]}(h)}}"
					elsif type[0] == :ref
						lineIn << "#{name}: in_#{name}(data[:#{@name}][:#{name}])"
						lineOut << "#{name}: out_#{name}(data[:#{name}])"
					else
						lineIn << "#{name}: data[:#{@name}][:#{name}]"
						lineOut << "#{name}: data[:#{name}]"
					end
				end

				hash_methods["out_#{@name}"] = %Q{ # {}
					def out_#{@name} data
						{#{@name}: {
							#{lineOut.join(",\n\t\t\t\t\t\t\t")}
						}}
					end
				}

				hash_methods["in_#{@name}"] = %Q{ # {}
					def in_#{@name} data
						{
							#{lineIn.join(",\n\t\t\t\t\t\t\t")}
						}
					end
				}

				hash_methods
			end

		end
	},
	:class_SOAPMethod => %q{ #{}
		class SOAPMethod
			# Вспомогательный класс-фабрика, предназначенный для генерации SOAP-методов, которые будут вызываться при обращении к SOAP-сервису

			def initialize name
				@name = name.to_s.to_sym

				@input = nil
				@output = nil
				@script = nil
				@role = nil
			end

			def setRole role
				# устанавливает роль, которой должен обладать авторизирующийся пользователь, что бы получить доступ к методу
				@role = role
			end

			def params type_name
				# устанавливает структуру, которую необходимо присылать в запросе
				@input = type_name.to_s.to_sym
				self
			end

			def returns type_name
				# устанавливает структуру, которую метод будет отправлять в ответ на запрос
				@output = type_name.to_s.to_sym
				self
			end

			def script script_text
				# тело метода, которое будет обернуто во все необходимое для работы
				@script = script_text
				self
			end

			def get_input
				# возвращает наименование структуры которую необходимо получать в запросе
				@input || @output || @name
			end

			def get_output
				# возвращает наименование структуры которую необходимо отправлять в ответ на запрос
				@output || @input || @name
			end

			def get_name
				# возвращает наименование метода
				@name
			end


			def generate_to_module hash_methods, activeUser = true, debug = false
				# метод генерирует SOAP-метода в модуль

				args = '#{args}'
				result = '#{result}'
				msg = '#{err.message}'
				trace = '#{err.backtrace.join("\n\t")}'
				namesoap = '#{namesoap}'

				# если включена авторизация, то будет сгенерирован код проверки пользователя и его ролей, для определения доступа к методу
				userScript = activeUser ? %q{
			raise "Ошибка авторизации пользователя" if @user.nil?
			@logger.info "SoapMethod[#{namesoap}.%{name}] Авторизация пользователя: #{@user}"
			@user = User::Users.get_by_login(@user)
			@logger.info "SoapMethod[#{namesoap}.%{name}] User.roles: #{@user.roles.inspect}"
			if access? %{role}
				@logger.info "SoapMethod[#{namesoap}.%{name}] Использование запроса одобренно"
			else
				raise "В доступе отказано! Убедитесь, что вы обладаете правами на использование запроса."
			end
				} % {name: @name, role: @role.inspect} : '';

				# генерация самого метода
				hash_methods[@name] = %Q{def #{@name} args
			args = in_#{get_input}( args )
			result = {}

			@logger.info "SoapMethod[#{namesoap}.#{@name}] start '#{args}'"

			@user = User.getSoapUser
			#{userScript}

			begin
				#{@script}
			rescue => err
				@logger.error "SoapMethod[#{namesoap}.#{@name}] error [result => '#{result}']  message: #{msg}\n\t#{trace}"
				error "SoapMethod[#{namesoap}.#{@name}] error [result => '#{result}']  message: #{msg}\n\t#{trace}"
				raise err.message
			end
			#{debug ? %Q[@logger.debug "SoapMethod[#{namesoap}.#{@name}] result => '#{result}'"] : ''}
			@logger.info "SoapMethod[#{namesoap}.#{@name}] finish"

			begin
				out_#{get_output}( result )
			rescue => err
				@logger.error "SoapMethod[#{namesoap}.#{@name}] ошибка структуры данных [result => '#{result}']  message: #{msg}\n\t#{trace}"
				error "SoapMethod[#{namesoap}.#{@name}] ошибка структуры данных [result => '#{result}']  message: #{msg}\n\t#{trace}"
				raise err.message
			end
		end} if @script

				hash_methods
			end

			def generate_to_soap soap
				# метод генерирует определение SOAP-метода в объект SOAP-сервиса
				this = self

				soap.operation @name do
					input this.get_input
					output this.get_output
				end
			end
		end
	},
	:class_SOAP => %q{ #{}
		class SOAP
			# Вспомогательный класс-фабрика, предназначенный для генерации всего необходимого для работы сервера, а точнее:
			#   1. Модуль SOAP-сервиса, в который будут помещены методы конвертации данных, а так же методы SOAP-сервиса
			#   2. Находит и удаляет предыдущий объект данного SOAP-сервиса (можно только создавать и удалять данные объекты, редактировать нет возможности)
			#   3. Создание класса SOAP-сервиса, с подгруженным в него модулями. Данный класс подключается к WebContainer (SOAP)
			#   4. Cоздание и настройка WebContainer сервиса, для плагина указанным по умолчанию в константе DEF_PLUGIN
			#   5. Создает объект WebServiceApi, в который подключается класс SOAP-сервиса, и является SOAP-объектом

			def initialize name
				@service_name = name.to_s.to_sym
				@namespace = nil
				@methods = []
				@types = []
				@module_methods = {
					namesoap:     "def namesoap; '#{name}'; end",
					service_role: "def service_role; nil; end"				}
				@includes = [:SOAPInit]
				@plugin = DEF_PLUGIN
				@description = Time.now.to_s
				plg = User::Plugin.get(@plugin).settings[:connectors][0]
				@port = plg[:port]
				@domain = plg[:host] #$control.this_node.ip
				@usertoken = true
				@role = nil
				@debug = false
			end
			
			def domain url
				# визуальное указание домена, которое будет отображаться в списке SOAP-сервисов
				@domain = url
			end

			def debug param = true
				# вклучить режим отладки (более расширенная запись в лог SOAP-сервиса)
				@debug = param
			end

			def service_role role
				# устанавливает общую роль сервиса, которой должен обладать авторизирующийся пользователь
				@module_methods[:service_role] = "def service_role; #{role.inspect}; end"
			end

			def methods_role role
				# устанавливает локальную роль метода, которой должен обладать авторизирующийся пользователь
				@role = role
			end

			def description text
				# описание сервиса
				@description = text + ' ' + Time.now.to_s
			end

			def port num
				# установка порта, если тот отличается от порта плагина
				@port = num
			end

			def soapType name, &block
				# определяет структуру данных, где:
				#   name   - наименование структуры данных
				#   &block - DSL блок структуры, в котором указывается набор данных в стиле C/C++ структуры

				tp = SOAPType.new name
				tp.instance_eval(&block) if block_given?
				@types << tp
				self
			end

			def usertoken uname = true
				# позволяет включить/отключить необходимость в авторизации пользователя
				@usertoken = uname
			end

			def soapMethod name, *inout, script_body
				# определяет SOAP-метод, где:
				#   name        - имя метода, которое будет так же отображаться в WSDL SOAP-сервиса
				#   inout       - представляет собой 0, 1 или 2 значения, где 
				#       1 - структура, переданная в запросе, которую ожидает метод
				#       2 - структура, отправляемая в ответ на запрос
				#   script_body - строковок тело метода, которое будет выполнино, при его вызове в SOAP

				mtd = SOAPMethod.new name
				params, returns = inout
				mtd.params params if params
				mtd.returns returns if returns
				mtd.script script_body
				mtd.setRole @role
				@methods << mtd
				self
			end

			def moduleMethods method_adds
				# метод позволяет включить в модуль SOAP-сервиса другие методы, которые описываются так же как и при обычном описании модуля вектора
				@module_methods.merge! method_adds
				self
			end

			def namespace name_space
				# окружение имен, которое будет вставленно в WSDL, и будет использоваться при формировании и чтения XML
				@namespace = name_space
				self
			end

			def modules *args
				# набор модулей, которые необходимо включить в класс SOAP-сервиса
				@includes += args
				self
			end

			def plugin plgn = nil
				# метод позволяет установить конфигурирование SOAP-сервиса для другого плагина, если он отличается от плагина по умолчанию
				return @plugin if plgn.nil?
				@plugin = plgn
				self
			end


			def run
				# запускает генерацию и настройку всего необходимого для работы SOAP-сервиса
				@namespace ||= "http://#{@service_name}.soap:#{@port}/"

				mdl = "#{@service_name}Module".to_sym
				clss = @service_name
				srvc_name = @service_name.to_s
				incld = @includes
				namespace = @namespace
				mtds = @methods
				tps = @types
				desc = @description
				uname = @usertoken

				# генерируем методы конвертации структур и SOAP-методы для модуля SOAP-сервиса
				md_mtds = @methods.inject(@module_methods){|res,mtd| mtd.generate_to_module res, uname, @debug}
				md_mtds = @types.inject(md_mtds){|res,tp| tp.generate_to_module res}

				# Ищим старый объект данного SOAP-сервиса, для его удаления
				User::Storage.each do |st|
					if st == "WebServiceDefinitions"
						str = User::Storage.get(st)
						str.objects.each do |obj_id, obj|
							if obj.service_name == srvc_name
								User::UserObject.del_object(obj)
								break
							end
						end
						break
					end
				end

				# удаляет класс, для его пересоздания
				User::UserClass.delete(clss) if User::UserClass.get(clss)


				# пересоздаем модуль, с новыми методами (пересоздаем для удаления остаточного мусора, если что-то убираем)
				User::Module.send  (User::Module.get(mdl) ? :recreate : :create), mdl do
					description desc
					modules *incld
					methods md_mtds
				end

				# создаем класс с уже обновленным модулем
				User::UserClass.create clss do
					description desc
					modules mdl
				end


				# настраиваем SOAP-сервис на работу из вне, вешая его на указанный плагин
				raise "плагин '#{@plugin}' несуществует, возможно неверно настроенны константы модуля 'UniversalSOAPhttp'" unless User::Plugin.get(@plugin)
				plng = @plugin
				User::WebContainer.modify do
					plugins plng
					handler "soap_#{srvc_name}".to_sym do
						type :soap
						context_path "/#{srvc_name}/*"
						user_class clss
						service_name clss
						namespace_uri namespace
						usertokenTokenOnly uname
					end
				end

				# создаем непосредственно сам объект SOAP-сервиса
				User::WebServiceApi.create(clss, @namespace, "http://#{@domain}:#{@port}/#{@service_name}/#{@service_name}") do
					plugins plng
					tps.each{|tp| tp.generate_to_soap self}
					mtds.each{|mtd| mtd.generate_to_soap self}
				end

			end

			def delete
				# метод удаляет все, что связанно с текущим SOAP-сервисом
				mdl = "#{@service_name}Module".to_sym
				clss = @service_name
				srvc_name = @service_name.to_s

				# Ищим старый объект данного SOAP-сервиса, для его удаления
				User::Storage.each do |st|
					if st == "WebServiceDefinitions"
						str = User::Storage.get(st)
						str.objects.each do |obj_id, obj|
							if obj.service_name == srvc_name
								User::UserObject.del_object(obj)
								break
							end
						end
						break
					end
				end
				User::Module.delete mdl
				User::UserClass.delete clss

				raise "плагин '#{@plugin}' несуществует, возможно неверно настроенны константы модуля 'UniversalSOAPhttp'" unless User::Plugin.get(@plugin)
				plng = @plugin

				# удаляем адрес SOAP-сервиса из указанного плагина
				User::WebContainer.modify do
					plugins plng
					drop_handlers "soap_#{srvc_name}".to_sym
				end
			end
		end
	},
	:self_create => %q{ #{}
		def self.create name, &block
			# метод создает/пересоздает SOAP-сервис, где:
			#   name   - наименование SOAP-сервиса
			#   &block - DSL-описание SOAP-сервиса
			soap = SOAP.new name
			soap.instance_eval(&block)
			soap.run

			# необходимо после прогона сделать перезапуск плагина

			#User::Plugin.stop soap.plugin
			#User::Plugin.start soap.plugin
		end
	},
	:self_pluginReStart => %q{
		def self.pluginReStart plugin = nil
			# метод перезапускает плагин по умолчанию
			plugin ||= DEF_PLUGIN
			User::Plugin.stop plugin
			User::Plugin.start plugin
		end
	},
	:self_delete => %q{ #{}
		def self.delete name, plugins = DEF_PLUGIN
			# метод удаляет SOAP-сервис из системы вектора
			# необходимо после прогона сделать перезапуск плагина
			SOAP.new(name).plugin(plugins).delete
		end
	},
	:self_readme => %q{ #{}
		def self.readme *methods_readme
			# мини-хелпик, по работе с данным модулем

			methods_readme = [:readme,:createSoapPlugin,:create,:delete,:soapType,:soapMethod,:namespase,:usertoken,:service_role,:method_role,:plugin,:port,:modules,:moduleMethods,:description] if methods_readme.empty?
			puts "HELP For: #{methods_readme.inspect}\n-----------------------------------------\n"

			methods_readme.each do |mthd|
				case mthd
					when :readme
						puts "User::UniversalSOAPhttp.readme [<helpMethod> [,...]]"
						puts "\t- Метод возвращает описание указанных методов, или всех, если оставить без параметров"
						puts "\thelpMethod - наименование интересующего метода, применяемого в модуле. доступны следующий набор:"
						puts "\t\t:readme, :createSoapPlugin, :create, :delete, :soapType, :soapMethod, :namespase, :plugin, :port, :modules, :moduleMethods, :description\n\n"

					when :delete
						puts "User::UniversalSOAPhttp.delete <NameSOAP> [, <plugin>]"
						puts "\t- Позволяет удалить все объекты создынные для SOAP-сервиса"
						puts "\tNameSOAP - Наименование SOAP-сервиса, который слдует удалить"
						puts "\tplugin   - Наименование плагина, в котором зарегестрирован SOAP-сервис, поумолчанию '#{DEF_PLUGIN}'\n\n"

					when :createSoapPlugin
						puts "User::UniversalSOAPhttp.createSoapPlugin"
						puts "\t- создает все необходимое для работы SOAP-сервиса по указанным константам,"
						puts "следует незабывать создать в файле 'plugin_config.rb' слудующие строчки (если при вызове вы неувидите надпись, что этот файл был изменен):"
						puts "{\n\t'name' => 'SoapServer',\n\t'description' => 'embedded soap server',\n\t'path' => 'jetty/rvec_plugin.rb',\n\t'class' => '::JettyHttpServer::Plugin'\n}"
						puts "\tзапускать данный метод стоит 1 раз, далее после перезагрузки Вектора, SOAP-сервер будет запущен по порту '#{PORT}',"
						puts "\tа посмотреть все сервисы можно будет по 'http://<IP-адрес сервера>:<порт сервера>/services_repository/'\n\n"

					when :create
						puts "User::UniversalSOAPhttp.create <NameSOAP> do\n\t<BLOCK_Optional>\nend"
						puts "\t- Создает/Пересоздает SOAP-сервис (все необходимые для его работы объекты, а так же связку между ними)"
						puts "\tNameSOAP       - Наименование SOAP-сервиса, который слдует создать/пересоздать"
						puts "\tBLOCK_Optional - В данном блоке описываются параметры, типы и методы SOAP-сервиса"
						puts "\t\tсмотрите помощ по следующим методам: :soapType, :soapMethod, :namespase, :plugin, :port, :modules, :moduleMethods, :description \n\n"

					when :soapType
						puts "...\n\tsoapType <NameType> do\n\t\t<record_types>\n\tend\n..."
						puts "\t- Создает SOAP-тип, который можно использовать в дальнейшем."
						puts "\tNameType     - Название SOAP-типа."
						puts "\trecord_types - поля SOAP-типа, имеют общий формат: <тип> <имя>"
						puts "\t\t<имя> - имя поля, в котором будет ожидаться указанный тип данных"
						puts "\t\t<тип> - один из доступных SOAP-типов:"
						puts "\t\t\tstring       - строка/текст"
						puts "\t\t\tinteger      - целое число со знаком, неограниченного размера"
						puts "\t\t\tlong         - целое число со знаком, размером в 8 байта"
						puts "\t\t\tint          - целое число со знаком, размеров в 4 байта"
						puts "\t\t\tshort        - целое число со знаком, размером в 2 байт"
						puts "\t\t\tdecimal      - вещественное число, с фиксированной точкой"
						puts "\t\t\tdouble       - вещественное число, размером в 8 байт"
						puts "\t\t\tfloat        - вещественное число, размером в 4 байт"
						puts "\t\t\tboolean      - логическое значение, может хранить значение 'true' или 'false'"
						puts "\t\t\tdateTime     - дата и время в формате 'ГГГГ-ММ-ДДTЧЧ:ММ:СС', стоит так же незабывать, что в метод будет передан не рубевый тип Time, а Java-вский"
						puts "\t\t\tbase64Binary - любые данные любого размера, при передаче преобразуются по алгоритму Base64"
						puts "\t\t ! в системе также существуют структурные типы"
						puts "\t\t\tarray <имя>, <SOAP-тип>"
						puts "\t\t\t\t- создание массивов, указанной структуры SOAP-типа"
						puts "\t\t\tref <SOAP-тип>"
						puts "\t\t\t\t- создает вложенный SOAP-тип\n\n"

					when :soapMethod
						puts "...\n\tsoapMethod <NameMethod>, <InType>, <OutType>, <Script>\n..."
						puts "\t- Создает SOAP-метод, и аналогичный метод-обработчик в модуле SOAP-сервиса"
						puts "\tNameMethod - наименование SOAP-метода"
						puts "\tInType     - SOAP-тип, который ожидается в запросе на входе"
						puts "\tOutTpye    - SOAP-тип, который нужно будет отправить на выходе, в качестве ответа"
						puts "\tScript     - тело метода-обработчика, в который будет существовать следующие переменные:"
						puts "\t\targs   - являться хешом входного SOAP-типа"
						puts "\t\tresult - хеш, изначально пустой, ожидается, что будет заполнен в соответствии с выходным SOAP-типом\n\n"

					when :namespase
						puts "...\n\tnamespase <namespase>\n..."
						puts "\t- Позволяет настроить окружение имен, которое будет использоваться SOAP-сервисом (необязательный)"
						puts "\tnamespase - окружение имен\n\n"

					when :usertoken
						puts "...\n\tusertoken <active_usertoken>\n..."
						puts "\t- Позволяет настроить ожидание авторизации"
						puts "\tactive_usertoken - false: если аторизация пользователя не требуется, и true: если она необходима"

					when :service_role
						puts "...\n\tservice_role <role>\n..."
						puts "\t- Позволяет установить наименование прав, на весь сервис, при этом у метода может быть свое наименование прав, в этом случае должны присутствовать оба права"
						puts "\trole - nil или наименование прав"

					when :methods_role
						puts "...\n\tmethods_role <role>\n..."
						puts "\t- Позволяет установить наименование прав, на последующие соап-методы, при этом у сервиса может быть свое наименование прав, в этом случае должны присутствовать оба права"
						puts "\trole - nil или наименование прав"

					when :plugin
						puts "...\n\tplugin <namePlugin>\n..."
						puts "\t- Позволяет указать плагин, в рамках которого будет работать SOAP-сервис (необязательный)"
						puts "\tnamePlugin - наименование плагина\n\n"

					when :port
						puts "...\n\tpotr <port>\n..."
						puts "\t- Позволяет указать порт, необходим, в случае, если используется не плагин по умолчанию, порт должен настраиваться, в соответствии с этим плагином"
						puts "\tport - порт, по которому бедет работать SOAP-сервис\n\n"

					when :description
						puts "...\n\tdescription <descript>\n..."
						puts "\t- Примечание/описание/пояснение SOAP-сервиса"
						puts "\tdescript - текст описания, в конце будет автоматически добавляться число и время запуска\n\n"

					when :modules
						puts "...\n\tmodules <module> [, ...]\n..."
						puts "\t- Подключает модули к модулю SOAP-сервиса, в описании SOAP-метода можно будет использовать их методы"
						puts "\tmodule - наименование подключаемого модуля\n\n"

					when :moduleMethods
						puts "...\n\tmoduleMethods <methodName> => <methodScript> [, ...]\n..."
						puts "\t- Создает методы, которые можно будет в дальнейшем использовать в коде SOAP-методов"
						puts "\tmethodName   - название метода, для модуля (имя для Вектора)"
						puts "\tmethodScript - текст с методом\n\n"
				end
			end
		end
	},
	:self_initialize_modules => %q{ # {}
		def self.initialize_modules *args
			tmp = 0
			(args.empty? ? Module : args).each do |mdl|
				md = User.const_get(mdl)
				if md.respond_to? :soap_initialize
					begin
						md.soap_initialize
						tmp += 1
					rescue
						puts '[ERROR] :#{mdl}'
					end
				end
			end
			tmp
		end
	}

end