UniversalSOAPhttp.create :ISUZT_NS_NSI_SOAP do
	description "автор: Сергеев Д.Н. "
	usertoken false
	service_role :Soap_ASUST
	domain 'svrw-isugt-wb.svrw.oao.rzd'
	#port 8080
	#debug

	soapType :paramESR do
		int :esr
	end

	soapType :paramID do
		integer :id
	end
	
	soapType :Classification do
		integer :IDCLASSIFICATION   # идентификатор
		integer :IDLEVEL            # уровень вложенности
		string  :NAMECLASSIFICATION # наименование
		string  :COMMENTS           # комментарии
		dateTime :DATEINPUT          # дата изменения (TIMESTAMP)
		string  :GUID               # уникальный идентификатор
		integer :IDCLASSIFICATIONTOPLEVEL_FK # ссылка на родительскую запись 
		string  :IDHIERARCHY        # иерархический идентификатор
		integer :IDCLASSIFICATOR_FK # идентификатор справочника
	end
	
	soapType :Classification_data do
		array :Classifications, :Classification
	end

	soapType :TRA_Area do
		integer  :idarea            # Идентификатор парка
		integer  :idlevel           # Уровень вложенности
		string  :numberarea        # Краткое наименование парка
		string  :namearea          # Наименование парка
		string  :descriptionarea   # Описание
		string  :comments          # Комментарий
		dateTime  :dateinput         # Дата изменения (TIMESTAMP)
		string  :guid              # Уникальный идентификатор
		integer  :idareatoplevel # Ссылка на родительскую запись 
		string  :idhierarchy       # Иерархический идентификатор
		integer  :idorganizationunit # Идентификатор станции
		dateTime :ont_time_write    # Дата записи (TIMESTAMP)
		string  :classifications # Массив классификаций
		string  :props  # Ассоциативный массив (Карта) доп свойств парка
	end

	soapType :TRA_Area_data do
		array :TRA_Areas, :TRA_Area
	end

	soapType :TRA_Railroad do
		integer :idrailroad        # Идентификатор пути
		integer :idlevel           # Уровень вложенности
		string  :numberrailroad    # Номер пути
		string  :namerailroad      # Наименование пути
		string  :descriptionrailroad   # Описание
		string  :comments          # Комментарий
		dateTime :dateinput         # Дата изменения (TIMESTAMP)
		string  :guid              # Уникальный идентификатор
		string :idrailroadtoplevel    # Ссылка на родительскую запись 
		string  :idhierarchy       # Иерархический идентификатор
		integer :idorganizationunit# Идентификатор станции
		dateTime :ont_time_write    # Дата записи (TIMESTAMP)
		string  :classifications   # Массив классификаций
		string  :props             # Ассоциативный массив (Карта) доп свойств парка
	end

	soapType :TRA_Railroad_data do
		array :TRA_Railroads, :TRA_Railroad
	end

	soapType :TRA_Device do
		integer :id          # Идентификатор устройства
		integer :idLevel           # Уровень вложенности
		string  :numberDevice      # Номер усройства
		string  :nameDevice        # Наименовние усройства
		string  :descriptionDevice # Описание
		string  :comments          # Комментарий
		dateTime :dateInput         # Дата изменения (TIMESTAMP)
		string  :guid              # Уникальный идентификатор
		integer :idDeviceTopLevel  # Ссылка на родительскую запись 
		string  :idHierarchy       # Иерархический идентификатор
		integer :idOrganizationUnit# Идентификатор станции
		dateTime :ont_time_write    # Дата записи (TIMESTAMP)
		string  :classifications   # Массив классификаций
		string  :props             # Ассоциативный массив (Карта) доп свойств парка
	end

	soapType :TRA_Device_data do
		array :TRA_Devices, :TRA_Device
	end

	soapType :TRA_RailroadNormative do
		integer :id
		integer :idOrganizationUnit
		integer :idRailroad
		string  :nameNormative
		string  :descriptionNormative
		string  :comments
		dateTime :dateInput  # (TIMESTAMP)
		string  :layout
	end

	soapType :TRA_RailroadNormative_data do
		array :TRA_RailroadNormatives, :TRA_RailroadNormative
	end

	soapType :TRA_Process do
		integer :idParent
		integer :id                  # Идентификатор записи
		integer :idOrganizationUnit  # Идентификатор станции
		integer :idDocumentStructure # Идентификатор раздела
		integer :idDocument          # Идентификатор документа
		int     :idLevel             # уровень вложенности
		int  :num                 # Номер по порядку
		integer :type                # Тип (график/группа/операция)
		string  :name                # Наименование операции
		integer :idModel             # Идентификатор шаблонной операци
		integer :duration            # продолжительность
		int :restrictionType     # Тип зависимости
		integer :restrictionId       # Идентификатор операции от которой зависит данная операция
		integer :restrictionEndId    # Идентификатор конечной операции от которой зависит данная операция для
		string  :resources           # Перечень исполнителей
		dateTime :ont_time_write      # Дата записи (TIMESTAMP)
		string  :classifications   # Массив классификаций
		string  :props               # Ассоциативный массив (Карта) доп свойств парка
	end

	soapType :TRA_Process_data do
		array :TRA_Processes, :TRA_Process
	end

	#----------------------------------------------------------------------
	soapMethod :get_classifications_by_idclassificator, :paramID, :Classification_data, <<-'METHOD'
		result[:Classifications] = hashReKeys TRA_Classifications.get_classifications_by_idclassificator(args[:id])
	METHOD

	soapMethod :Areas_findByEsr, :paramESR, :TRA_Area_data, <<-'METHOD'
		result[:TRA_Areas] = hashReKeys TRA_Areas.findByEsr(args[:esr]) 
	METHOD

	soapMethod :Railroads_findByEsr, :paramESR, :TRA_Railroad_data, <<-'METHOD'
		result[:TRA_Railroads] = hashReKeys TRA_Railroads.findByEsr(args[:esr])
	METHOD

	soapMethod :findWagonDeviceByEsr, :paramESR, :TRA_Device_data, <<-'METHOD' 
		result[:TRA_Devices] = hashReKeys TRA_Devices.findWagonDeviceByEsr(args[:esr])
	METHOD

	soapMethod :RailroadNormatives_findByEsr, :paramESR, :TRA_RailroadNormative_data, <<-'METHOD' 
		result[:TRA_RailroadNormatives] = hashReKeys TRA_RailroadNormatives.findByEsr(args[:esr])
	METHOD

	soapMethod :findBrakeShoeByEsr, :paramESR, :TRA_Device_data, <<-'METHOD' 
		result[:TRA_Devices] = hashReKeys TRA_Devices.findBrakeShoeByEsr(args[:esr])
	METHOD

	soapMethod :Process_findByEsr, :paramESR, :TRA_Process_data, <<-'METHOD' 
		result[:TRA_Processes] = hashReKeys TRA_Process.findByEsr(args[:esr])
	METHOD
	
end


UniversalSOAPhttp.pluginReStart